package cx.threeg.dcms.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JsoupBridge {
    public static boolean available(){
        try{ Class.forName("org.jsoup.Jsoup"); return true; }catch(Throwable t){ return false; }
    }
    public static List<HtmlLightParser.LinkItem> extractLinksWithJsoup(String html, String baseUrl, String[] keywords){
        List<HtmlLightParser.LinkItem> out = new ArrayList<HtmlLightParser.LinkItem>();
        try{
            Class<?> jsoup = Class.forName("org.jsoup.Jsoup");
            Method parse = jsoup.getMethod("parse", String.class, String.class);
            Object doc = parse.invoke(null, html, baseUrl);
            Class<?> docCls = Class.forName("org.jsoup.nodes.Document");
            Method select = docCls.getMethod("select", String.class);
            Object links = select.invoke(doc, "a[href]");
            Class<?> elements = Class.forName("org.jsoup.select.Elements");
            Class<?> element = Class.forName("org.jsoup.nodes.Element");
            Method size = elements.getMethod("size");
            Method get = elements.getMethod("get", int.class);
            Method text = element.getMethod("text");
            Method attr = element.getMethod("attr", String.class);
            int n = ((Integer)size.invoke(links)).intValue();
            for(int i=0;i<n;i++){
                Object el = get.invoke(links, i);
                String t = (String)text.invoke(el);
                if (t==null||t.trim().length()==0) continue;
                if (keywords!=null&&keywords.length>0){
                    boolean ok=false; for(String k:keywords){ if(k!=null&&k.trim().length()>0&&t.toLowerCase().contains(k.toLowerCase())){ ok=true; break; } }
                    if(!ok) continue;
                }
                String href = (String)attr.invoke(el, "abs:href");
                if (href==null||href.length()==0) href = (String)attr.invoke(el, "href");
                HtmlLightParser.LinkItem it = new HtmlLightParser.LinkItem(t, href, href);
                out.add(it);
            }
        }catch(Throwable t){ /* ignore */ }
        return out;
    }
}
